<?php
ob_start();
session_start();

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

$baseDir = "../videoHLS";
$ffmpegBinary = '/usr/bin/ffmpeg'; // Use absolute path
$video_url = $_GET['url'];
$topic_name = $_GET['topic_name'];

// Sanitize the topic name to be filesystem safe, if necessary
$sanitizedTopicName = preg_replace('/[^a-zA-Z0-9-_]/', '', $topic_name);

$inputVideo = "../videos/" . $video_url;

$outputDirectory = $baseDir;


$hlsSegmentFilename = "{$outputDirectory}/{$sanitizedTopicName}%d.ts";
$outputPlaylist = "{$outputDirectory}/{$sanitizedTopicName}.m3u8";
$encryptionKeyInfoFile = "encryption.keyinfo";


// Constructing the ffmpeg command
$ffmpegCommand = "{$ffmpegBinary} -i {$inputVideo} -hls_time 10 -hls_key_info_file {$encryptionKeyInfoFile} -hls_playlist_type vod -hls_segment_filename \"{$hlsSegmentFilename}\" {$outputPlaylist} 2>&1";

// Execute the ffmpeg command
exec($ffmpegCommand, $output, $returnVar);

if ($returnVar === 0) {
    // Video converted successfully, now zip the HLS files
    $zipFilename = "{$sanitizedTopicName}_hls.zip";
    $zipFile = $outputDirectory . "/" . $zipFilename;
    $zip = new ZipArchive();

    if ($zip->open($zipFile, ZipArchive::CREATE) === TRUE) {
        // Add the m3u8 file to the zip
        $zip->addFile($outputPlaylist, basename($outputPlaylist));

        // Add TS segment files to the zip
        foreach (glob("{$outputDirectory}/{$sanitizedTopicName}*.ts") as $filename) {
            $zip->addFile($filename, basename($filename));
        }

        // Close the zip file
        $zip->close();

        // Prepare headers to trigger the file download
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . basename($zipFile) . '"');
        header('Content-Length: ' . filesize($zipFile));

        // Clear any previous output
        if (ob_get_level()) {
            ob_clean();
        }
        flush();

        // Read the zip file and send it to the browser, initiating the download
        readfile($zipFile);

        // Cleanup: Delete the zip file and HLS files after sending to the browser
        unlink($zipFile);
        array_map('unlink', glob("{$outputDirectory}/{$sanitizedTopicName}*.ts"));
        unlink($outputPlaylist);
        
        echo "Video Downloaded Successfully";
        echo "<a href='https://demo.ca.educationverse.org/frontend/mymaterials.php'>Back to Screen</a>";

        // Redirection using JavaScript after file download
        // header("Location: ../../frontend/mymaterials.php");
        
        exit;
    } else {
        echo "Failed to create the zip file.";
        exit;
    }
} else {
    echo "An error occurred during the conversion process.\n";
    var_dump($output); // Display any error messages
    exit;
}

?>



// ob_start();
// session_start();

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// $baseDir = "../videoHLS";
// $ffmpegBinary = '/usr/bin/ffmpeg'; // Use absolute path
// $video_url = $_GET['url'];
// $topic_name = $_GET['topic_name'];

// // Sanitize the topic name to be filesystem safe, if necessary
// // This is a basic example, you may need a more robust solution
// $sanitizedTopicName = preg_replace('/[^a-zA-Z0-9-_]/', '', $topic_name);

// $inputVideo = "../videos/" . $video_url;

// $outputDirectory = $baseDir;
// // Include $sanitizedTopicName in the segment and playlist filenames
// $hlsSegmentFilename = "{$outputDirectory}/{$sanitizedTopicName}%d.ts";
// $outputPlaylist = "{$outputDirectory}/{$sanitizedTopicName}.m3u8";
// $encryptionKeyInfoFile = "encryption.keyinfo";

// // Constructing the ffmpeg command
// $ffmpegCommand = "{$ffmpegBinary} -i {$inputVideo} -hls_time 10 -hls_key_info_file {$encryptionKeyInfoFile} -hls_playlist_type vod -hls_segment_filename \"{$hlsSegmentFilename}\" {$outputPlaylist} 2>&1";

// // Execute the ffmpeg command
// exec($ffmpegCommand, $output, $returnVar);

// if ($returnVar === 0) {
//     // Video converted successfully, now zip the HLS files
//     $zipFilename = "{$sanitizedTopicName}_hls.zip";
//     $zipFile = $outputDirectory . "/" . $zipFilename;
//     $zip = new ZipArchive();

//     if ($zip->open($zipFile, ZipArchive::CREATE) === TRUE) {
//         // Add the m3u8 file to the zip
//         $zip->addFile($outputPlaylist, basename($outputPlaylist));

//         // Add TS segment files to the zip
//         foreach (glob("{$outputDirectory}/{$sanitizedTopicName}*.ts") as $filename) {
//             $zip->addFile($filename, basename($filename));
//         }

//         // Close the zip file
//         $zip->close();

//         // Prepare headers to trigger the file download
//         header('Content-Type: application/zip');
//         header('Content-Disposition: attachment; filename="' . basename($zipFile) . '"');
//         header('Content-Length: ' . filesize($zipFile));

//         // Clear any previous output
//         ob_clean();
//         flush();

//         // Read the zip file and send it to the browser, initiating the download
//         readfile($zipFile);

//         // Cleanup: Delete the zip file and HLS files after sending to the browser
//         unlink($zipFile);
//         array_map('unlink', glob("{$outputDirectory}/{$sanitizedTopicName}*.ts"));
//         unlink($outputPlaylist);
        
//         $_SESSION['video_download'] = "Video Downloaded Successfully";
        
//         header("Location: ../../frontend/mymaterials.php");
        
//         exit;
//     } else {
//         echo "Failed to create the zip file.";
//     }
// } else {
//     echo "An error occurred during the conversion process.\n";
//     var_dump($output); // Display any error messages
// }







